<?php
session_start();
if (!isset($_SESSION['user'])) {
    header('Location: ../index.php');
    exit();
} 
include 'tgl_indo.php';
include 'content/meta.php';
include 'content/header.php';
include 'content/asets.php';

$id_user = $_SESSION['id'];
include 'koneksi.php';

// Ambil jumlah produk
$jumlah_produk = 0;
$sql_produk = $db->query("SELECT COUNT(id_produk) AS total FROM produk");
if ($sql_produk && $sql_produk->num_rows > 0) {
    $row_produk = $sql_produk->fetch_assoc();
    $jumlah_produk = $row_produk['total'];
}

// Ambil jumlah karakteristik
$jumlah_karakteristik = 0;
$sql_karakteristik = $db->query("SELECT COUNT(*) AS total FROM kriteria");
if ($sql_karakteristik && $sql_karakteristik->num_rows > 0) {
    $row_karakteristik = $sql_karakteristik->fetch_assoc();
    $jumlah_karakteristik = $row_karakteristik['total'];
}
?>

<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0" style="color:white;">Dashboard</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Dashboard</li>
            </ol>
          </div>
        </div>
      </div>
    </div>

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          
          <!-- Box Produk -->
          <div class="col-lg-3 col-6">
            <a href="#">
              <div class="small-box bg-info">
                <div class="inner">
                  <h3><?php echo $jumlah_produk; ?></h3>
                  <p>Produk</p>
                </div>
                <div class="icon">
                  <i class="fa fa-file"></i>
                </div>
              </div>
            </a>
          </div>

          <!-- Box Karakteristik -->
          <div class="col-lg-3 col-6">
            <a href="#">
              <div class="small-box bg-success">
                <div class="inner">
                  <h3><?php echo $jumlah_karakteristik; ?></h3>
                  <p>Karakteristik</p>
                </div>
                <div class="icon">
                  <i class="fa fa-comment"></i>
                </div>
              </div>
            </a>
          </div>

        </div>
      </div>
    </section>
</div>

<?php 
include 'content/footer.php';
include 'content/script.php';
?>
