<?php
session_start();
if (!isset($_SESSION['user'])) {
    header('Location: ../index.php');
    exit();
}
include 'content/meta.php';
include 'content/header.php';
include 'content/asets.php';
error_reporting(0);
include 'koneksi.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="card">
            <div class="card-header text-center">
                <h3 class="card-title"><u>Daftar Produk</u></h3>
                <br>
                <?php if($_SESSION['level'] == "admin" || $_SESSION['level'] == "superadmin") { ?>
                    <a href="inptprdk.php" class="btn btn-warning" style="border-radius:25px;">Input Produk</a>
                    <a href="export.php" class="btn btn-info" style="border-radius:25px;">Export Produk</a>
                   
                <?php } ?>
            </div>

            <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Nama Produk</th>
                            <th>Gaya</th>
                            <th>Warna</th>
                            <th>Aktivitas</th>
                            <th>Skor Harga</th>
                            <th>Skor Trend</th>
                            <th>Skor Aktivitas</th>
                            <th>Skor Kecocokan Gaya</th>
                            <th>Cluster</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $no = 1;
                        $query = mysqli_query($db, "SELECT p.*, c.nama_cluster 
                                                   FROM produk p 
                                                   LEFT JOIN clusters c ON p.id_cluster = c.id_cluster 
                                                   ORDER BY p.id_produk DESC");
                        while ($row = mysqli_fetch_assoc($query)) {
                        ?>
                        <tr>
                            <td><?= $no++ ?></td>
                            <td><?= $row['nama_produk'] ?></td>
                            <td><?= $row['style'] ?></td>
                            <td><?= $row['warna'] ?></td>
                            <td><?= $row['aktivitas'] ?></td>
                            <td><?= $row['skor_harga'] ?></td>
                            <td><?= $row['skor_trend'] ?></td>
                            <td><?= $row['skor_aktivitas'] ?></td>
                            <td><?= $row['skor_kecocokangaya'] ?></td>
                            <td><?= $row['nama_cluster'] ?? 'Belum ditentukan' ?></td>
                            <td>
                                <a href="editpg1.php?id=<?= $row['id_produk'] ?>" class="btn btn-success" style="border-radius:25px;"><i class="fa fa-edit"></i></a>
                                <a href="hapusproduk.php?id=<?= $row['id_produk'] ?>" class="btn btn-danger" style="border-radius:25px;" onclick="return confirm('Apakah Anda yakin ingin menghapus data ini?')"><i class="fa fa-trash"></i></a>
                            </td>
                        </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </section>
</div>

<?php 
include 'content/footer.php';
include 'content/script.php';
?>