<?php
include 'koneksi.php';

// =============================================
// FUNGSI UTAMA DENGAN CLUSTER BERDASARKAN GAYA
// =============================================

function hitungJarak($point1, $point2) {
    return sqrt(
        pow($point1['harga'] - $point2['harga'], 2) +
        pow($point1['trend'] - $point2['trend'], 2) +
        pow($point1['aktivitas'] - $point2['aktivitas'], 2) +
        pow($point1['kecocokan'] - $point2['kecocokan'], 2)
    );
}

// Fungsi untuk menampilkan debug tabel
function debugTabel($data, $judul) {
    echo "<div class='card mb-4'>
            <div class='card-header bg-info text-white'>{$judul}</div>
            <div class='card-body'>
                <div class='table-responsive'>
                    <table class='table table-bordered table-sm'>
                        <thead class='thead-light'>
                            <tr>
                                <th>#</th>
                                <th>Produk</th>
                                <th>Gaya</th>
                                <th>Harga</th>
                                <th>Trend</th>
                                <th>Aktivitas</th>
                                <th>Kecocokan</th>
                                <th>Cluster</th>
                            </tr>
                        </thead>
                        <tbody>";

    foreach ($data as $i => $row) {
        $clusterDisplay = ($row['cluster'] == 0) ? 'Belum tercluster' : $row['cluster'];
        echo "<tr>
                <td>".($i+1)."</td>
                <td>{$row['nama']}</td>
                <td>{$row['style']}</td>
                <td>".number_format($row['harga'], 4)."</td>
                <td>".number_format($row['trend'], 4)."</td>
                <td>".number_format($row['aktivitas'], 4)."</td>
                <td>".number_format($row['kecocokan'], 4)."</td>
                <td class='text-center'>{$clusterDisplay}</td>
              </tr>";
    }

    echo "</tbody></table></div></div></div>";
}

// Fungsi untuk menampilkan debug centroid
function debugCentroid($centroids, $judul) {
    echo "<div class='card mb-3'>
            <div class='card-header bg-secondary text-white'>{$judul}</div>
            <div class='card-body'>
                <table class='table table-bordered table-sm'>
                    <thead>
                        <tr>
                            <th>Cluster</th>
                            <th>Gaya</th>
                            <th>Harga</th>
                            <th>Trend</th>
                            <th>Aktivitas</th>
                            <th>Kecocokan</th>
                        </tr>
                    </thead>
                    <tbody>";

    foreach ($centroids as $idx => $centroid) {
        echo "<tr>
                <td>{$idx}</td>
                <td>{$centroid['style']}</td>
                <td>".number_format($centroid['harga'], 4)."</td>
                <td>".number_format($centroid['trend'], 4)."</td>
                <td>".number_format($centroid['aktivitas'], 4)."</td>
                <td>".number_format($centroid['kecocokan'], 4)."</td>
              </tr>";
    }

    echo "</tbody></table></div></div>";
}

// Fungsi untuk menampilkan debug jarak
function debugJarak($produk, $centroids) {
    echo "<div class='card mb-4'>
            <div class='card-header bg-warning text-dark'>Perhitungan Jarak</div>
            <div class='card-body'>
                <table class='table table-bordered table-sm'>
                    <thead>
                        <tr>
                            <th>Produk</th>";

    for ($i = 1; $i <= count($centroids); $i++) {
        echo "<th>Cluster {$i}</th>";
    }

    echo "<th>Cluster Terdekat</th></tr></thead><tbody>";

    foreach ($produk as $item) {
        echo "<tr><td>{$item['nama']}</td>";
        
        $min_jarak = PHP_FLOAT_MAX;
        $cluster_terdekat = 0;
        
        foreach ($centroids as $idx => $centroid) {
            $jarak = hitungJarak($item, $centroid);
            echo "<td>".number_format($jarak, 4)."</td>";
            
            if ($jarak < $min_jarak) {
                $min_jarak = $jarak;
                $cluster_terdekat = $idx;
            }
        }
        
        echo "<td class='text-center'>{$cluster_terdekat}</td></tr>";
    }

    echo "</tbody></table></div></div>";
}

// Inisialisasi centroid berdasarkan gaya fashion yang ada di database
function initCentroids($produk) {
    $centroids = [];
    $gaya_uniq = [];
    
    // Identifikasi semua gaya fashion unik dari produk
    foreach ($produk as $item) {
        if (!in_array($item['style'], $gaya_uniq)) {
            $gaya_uniq[] = $item['style'];
        }
    }
    
    // Untuk setiap gaya fashion, hitung centroidnya
    $i = 1;
    foreach ($gaya_uniq as $gaya) {
        $items_gaya = array_filter($produk, function($item) use ($gaya) {
            return $item['style'] === $gaya;
        });
        
        $count = count($items_gaya);
        if ($count > 0) {
            $sum_harga = array_sum(array_column($items_gaya, 'harga'));
            $sum_trend = array_sum(array_column($items_gaya, 'trend'));
            $sum_aktivitas = array_sum(array_column($items_gaya, 'aktivitas'));
            $sum_kecocokan = array_sum(array_column($items_gaya, 'kecocokan'));
            
            $centroids[$i] = [
                'harga' => $sum_harga / $count,
                'trend' => $sum_trend / $count,
                'aktivitas' => $sum_aktivitas / $count,
                'kecocokan' => $sum_kecocokan / $count,
                'style' => $gaya
            ];
            $i++;
        }
    }
    
    return $centroids;
}

// =============================================
// PROSES UTAMA
// =============================================

// 1. Ambil data dari form
$gender = $_POST['gender'] ?? '';
$warna = $_POST['warna'] ?? '';
$harga_input = (float)($_POST['harga'] ?? 0);
$trend_input = (float)($_POST['trend'] ?? 0);
$aktivitas_input = (float)($_POST['aktivitas_penting'] ?? 0);
$kecocokan_input = (float)($_POST['gaya'] ?? 0);
$aktivitas_harian = $_POST['aktivitas'] ?? '';

// 2. Ambil data produk berdasarkan filter (gender, warna, aktivitas)
$stmt = $db->prepare("SELECT * FROM produk WHERE gender = ? AND warna = ? AND aktivitas LIKE ?");
$like_aktivitas = "%$aktivitas_harian%";
$stmt->bind_param("sss", $gender, $warna, $like_aktivitas);
$stmt->execute();
$result = $stmt->get_result();

$produk = [];
while ($row = $result->fetch_assoc()) {
    $produk[] = [
        'id' => $row['id_produk'],
        'nama' => $row['nama_produk'],
        'style' => $row['style'],
        'harga' => (float)$row['skor_harga'],
        'trend' => (float)$row['skor_trend'],
        'aktivitas' => (float)$row['skor_aktivitas'],
        'kecocokan' => (float)$row['skor_kecocokangaya'],
        'cluster' => 0,
        'cluster_gaya' => '' // Untuk menyimpan gaya cluster
    ];
}

// =============================================
// TAMPILKAN DEBUG PROSES
// =============================================
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Proses Perhitungan Rekomendasi Fashion</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .debug-section {
            background-color: #f8f9fa;
            border-left: 4px solid #6c757d;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 5px;
        }
        .highlight {
            background-color: #fff3cd !important;
        }
        .btn-back {
            background-color: #6c757d;
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 5px;
            text-decoration: none;
        }
        .btn-back:hover {
            background-color: #5a6268;
            color: white;
        }
        .cluster-badge {
            font-size: 0.8rem;
            padding: 0.3rem 0.6rem;
            border-radius: 15px;
        }
        .iteration-box {
            border: 1px solid #dee2e6;
            border-radius: 5px;
            padding: 15px;
            margin-bottom: 20px;
            background-color: #f8f9fa;
        }
    </style>
</head>
<body>
    <div class="container py-4">
        <h1 class="text-center mb-4">Proses Perhitungan Rekomendasi Fashion</h1>
        
        <!-- Parameter Input -->
        <div class="debug-section">
            <h2 class="text-primary">Parameter Input</h2>
            <div class="row">
                <div class="col-md-6">
                    <p><strong>Gender:</strong> <?= htmlspecialchars($gender) ?></p>
                    <p><strong>Warna:</strong> <?= htmlspecialchars($warna) ?></p>
                    <p><strong>Aktivitas Harian:</strong> <?= htmlspecialchars($aktivitas_harian) ?></p>
                </div>
                <div class="col-md-6">
                    <p><strong>Skor Harga:</strong> <?= $harga_input ?></p>
                    <p><strong>Skor Trend:</strong> <?= $trend_input ?></p>
                    <p><strong>Skor Aktivitas:</strong> <?= $aktivitas_input ?></p>
                    <p><strong>Skor Kecocokan:</strong> <?= $kecocokan_input ?></p>
                </div>
            </div>
        </div>

        <!-- Data Awal -->
        <div class="debug-section">
            <h2 class="text-primary">1. Data Awal Produk</h2>
            <div class="alert alert-info">
                Filter: Gender = <strong><?= htmlspecialchars($gender) ?></strong>, 
                Warna = <strong><?= htmlspecialchars($warna) ?></strong>, 
                Aktivitas = <strong><?= htmlspecialchars($aktivitas_harian) ?></strong>
            </div>
            
            <?php debugTabel($produk, "Data Produk Awal (".count($produk)." produk)"); ?>
        </div>

        <!-- Proses K-Means -->
        <div class="debug-section">
            <h2 class="text-primary">2. Proses K-Means Clustering</h2>
            
            <?php
            // 3. Inisialisasi centroid berdasarkan gaya fashion yang ada
            $centroids = initCentroids($produk);
            $k = count($centroids);
            
            echo "<div class='alert alert-info'>Jumlah Cluster (Gaya): <strong>{$k}</strong></div>";
            
            debugCentroid($centroids, "Centroid Awal Berdasarkan Gaya");
            
            // 4. Proses clustering
            $max_iterasi = 10;
            $iterasi = 0;
            $berubah = true;
            $clusterAssignments = array_fill(0, count($produk), 0);
            
            while ($iterasi < $max_iterasi && $berubah) {
                $iterasi++;
                $berubah = false;
                
                echo "<div class='iteration-box'>";
                echo "<h4 class='text-success'>Iterasi {$iterasi}</h4>";
                
                // Hitung jarak dan tetapkan cluster
                debugJarak($produk, $centroids);
                
                foreach ($produk as $idx => &$item) {
                    $jarak_terdekat = PHP_FLOAT_MAX;
                    $cluster_terdekat = 0;
                    
                    foreach ($centroids as $c_idx => $centroid) {
                        // Pastikan produk hanya masuk ke cluster dengan gaya yang sama
                        if ($item['style'] === $centroid['style']) {
                            $jarak = hitungJarak($item, $centroid);
                            if ($jarak < $jarak_terdekat) {
                                $jarak_terdekat = $jarak;
                                $cluster_terdekat = $c_idx;
                            }
                        }
                    }
                    
                    if ($clusterAssignments[$idx] != $cluster_terdekat) {
                        $berubah = true;
                        $clusterAssignments[$idx] = $cluster_terdekat;
                        $item['cluster'] = $cluster_terdekat;
                        $item['cluster_gaya'] = $centroids[$cluster_terdekat]['style'];
                    }
                }
                unset($item);
                
                debugTabel($produk, "Hasil Clustering Iterasi {$iterasi}");
                
                // Hitung ulang centroid
                $cluster_counts = array_fill(1, $k, 0);
                $cluster_sums = array_fill(1, $k, [
                    'harga' => 0, 'trend' => 0, 'aktivitas' => 0, 'kecocokan' => 0
                ]);
                
                foreach ($produk as $item) {
                    $cluster = $item['cluster'];
                    if ($cluster > 0) {
                        $cluster_counts[$cluster]++;
                        $cluster_sums[$cluster]['harga'] += $item['harga'];
                        $cluster_sums[$cluster]['trend'] += $item['trend'];
                        $cluster_sums[$cluster]['aktivitas'] += $item['aktivitas'];
                        $cluster_sums[$cluster]['kecocokan'] += $item['kecocokan'];
                    }
                }
                
                $centroid_baru = [];
                for ($i = 1; $i <= $k; $i++) {
                    $centroid_baru[$i] = [
                        'harga' => $cluster_counts[$i] ? $cluster_sums[$i]['harga'] / $cluster_counts[$i] : $centroids[$i]['harga'],
                        'trend' => $cluster_counts[$i] ? $cluster_sums[$i]['trend'] / $cluster_counts[$i] : $centroids[$i]['trend'],
                        'aktivitas' => $cluster_counts[$i] ? $cluster_sums[$i]['aktivitas'] / $cluster_counts[$i] : $centroids[$i]['aktivitas'],
                        'kecocokan' => $cluster_counts[$i] ? $cluster_sums[$i]['kecocokan'] / $cluster_counts[$i] : $centroids[$i]['kecocokan'],
                        'style' => $centroids[$i]['style']
                    ];
                }
                
                debugCentroid($centroid_baru, "Centroid Baru Iterasi {$iterasi}");
                $centroids = $centroid_baru;
                echo "</div>";
            }
            
            // 5. Tentukan cluster terdekat dengan user
            $user_point = [
                'harga' => $harga_input,
                'trend' => $trend_input,
                'aktivitas' => $aktivitas_input,
                'kecocokan' => $kecocokan_input
            ];
            
            $jarak_terdekat = PHP_FLOAT_MAX;
            $user_cluster = 0;
            $user_cluster_gaya = '';
            $jarak_cluster = [];
            
            foreach ($centroids as $idx => $centroid) {
                $jarak = hitungJarak($user_point, $centroid);
                $jarak_cluster[$idx] = $jarak;
                
                if ($jarak < $jarak_terdekat) {
                    $jarak_terdekat = $jarak;
                    $user_cluster = $idx;
                    $user_cluster_gaya = $centroid['style'];
                }
            }
            
            echo "<div class='alert alert-success'>
                    <h5>Cluster Terdekat dengan Profil Pengguna</h5>
                    <p>Gaya: <strong>{$user_cluster_gaya}</strong></p>
                    <table class='table table-bordered'>
                        <thead>
                            <tr>
                                <th>Cluster</th>
                                <th>Gaya</th>
                                <th>Jarak ke Profil</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>";
            
            foreach ($jarak_cluster as $idx => $jarak) {
                $status = ($idx == $user_cluster) ? 
                    "<span class='badge bg-success'>Terdekat</span>" : 
                    "<span class'badge bg-secondary'>-</span>";
                
                echo "<tr>
                        <td>{$idx}</td>
                        <td>{$centroids[$idx]['style']}</td>
                        <td>".number_format($jarak, 4)."</td>
                        <td>{$status}</td>
                      </tr>";
            }
            
            echo "</tbody></table></div>";
            
            // 6. Filter produk dari cluster terdekat
            $produk_cluster = array_filter($produk, function($item) use ($user_cluster_gaya) {
                return $item['style'] === $user_cluster_gaya;
            });
            
            echo "<div class='alert alert-info'>
                    <strong>Jumlah Produk dalam Cluster Terdekat ({$user_cluster_gaya}):</strong> ".count($produk_cluster)."
                  </div>";
            
            debugTabel(array_values($produk_cluster), "Produk dalam Cluster Terdekat");
            ?>
        </div>

        <!-- Proses MOORA -->
        <div class="debug-section">
            <h2 class="text-primary">3. Proses MOORA pada Cluster Terdekat</h2>
            
            <?php
            // 7.1. Normalisasi matriks keputusan
            $sum_sq = ['harga' => 0.0001, 'trend' => 0.0001, 'aktivitas' => 0.0001, 'kecocokan' => 0.0001];
            
            foreach ($produk_cluster as $item) {
                $sum_sq['harga'] += pow($item['harga'], 2);
                $sum_sq['trend'] += pow($item['trend'], 2);
                $sum_sq['aktivitas'] += pow($item['aktivitas'], 2);
                $sum_sq['kecocokan'] += pow($item['kecocokan'], 2);
            }
            
            echo "<div class='mb-4'>
                    <h4>Langkah 1: Hitung Sum of Squares</h4>
                    <table class='table table-bordered'>
                        <tr>
                            <th>Kriteria</th>
                            <th>Sum of Squares</th>
                        </tr>
                        <tr><td>Harga</td><td>".number_format($sum_sq['harga'], 4)."</td></tr>
                        <tr><td>Trend</td><td>".number_format($sum_sq['trend'], 4)."</td></tr>
                        <tr><td>Aktivitas</td><td>".number_format($sum_sq['aktivitas'], 4)."</td></tr>
                        <tr><td>Kecocokan</td><td>".number_format($sum_sq['kecocokan'], 4)."</td></tr>
                    </table>
                  </div>";
            
            // Normalisasi
            $normalized = [];
            foreach ($produk_cluster as $item) {
                $normalized[] = [
                    'id' => $item['id'],
                    'nama' => $item['nama'],
                    'harga' => $item['harga'] / sqrt($sum_sq['harga']),
                    'trend' => $item['trend'] / sqrt($sum_sq['trend']),
                    'aktivitas' => $item['aktivitas'] / sqrt($sum_sq['aktivitas']),
                    'kecocokan' => $item['kecocokan'] / sqrt($sum_sq['kecocokan']),
                    'cluster' => $item['cluster'],
                    'style' => $item['style']
                ];
            }
            
            echo "<div class='mb-4'>
                    <h4>Langkah 2: Matriks Ternormalisasi</h4>
                    <table class='table table-bordered'>
                        <thead>
                            <tr>
                                <th>Produk</th>
                                <th>Harga</th>
                                <th>Trend</th>
                                <th>Aktivitas</th>
                                <th>Kecocokan</th>
                            </tr>
                        </thead>
                        <tbody>";
            
            foreach ($normalized as $item) {
                echo "<tr>
                        <td>{$item['nama']}</td>
                        <td>".number_format($item['harga'], 4)."</td>
                        <td>".number_format($item['trend'], 4)."</td>
                        <td>".number_format($item['aktivitas'], 4)."</td>
                        <td>".number_format($item['kecocokan'], 4)."</td>
                      </tr>";
            }
            
            echo "</tbody></table></div>";
            
            // 7.2. Hitung bobot kriteria
            $total_bobot = $harga_input + $trend_input + $aktivitas_input + $kecocokan_input;
            if ($total_bobot == 0) $total_bobot = 1;
            
            $bobot = [
                'harga' => $harga_input / $total_bobot,
                'trend' => $trend_input / $total_bobot,
                'aktivitas' => $aktivitas_input / $total_bobot,
                'kecocokan' => $kecocokan_input / $total_bobot
            ];
            
            echo "<div class='mb-4'>
                    <h4>Langkah 3: Bobot Kriteria</h4>
                    <table class='table table-bordered'>
                        <tr>
                            <th>Kriteria</th>
                            <th>Input</th>
                            <th>Bobot</th>
                            <th>Tipe</th>
                        </tr>
                        <tr>
                            <td>Harga</td>
                            <td>{$harga_input}</td>
                            <td>".number_format($bobot['harga'], 4)."</td>
                            <td><span class='badge bg-danger'>Cost</span></td>
                        </tr>
                        <tr>
                            <td>Trend</td>
                            <td>{$trend_input}</td>
                            <td>".number_format($bobot['trend'], 4)."</td>
                            <td><span class='badge bg-success'>Benefit</span></td>
                        </tr>
                        <tr>
                            <td>Aktivitas</td>
                            <td>{$aktivitas_input}</td>
                            <td>".number_format($bobot['aktivitas'], 4)."</td>
                            <td><span class='badge bg-success'>Benefit</span></td>
                        </tr>
                        <tr>
                            <td>Kecocokan</td>
                            <td>{$kecocokan_input}</td>
                            <td>".number_format($bobot['kecocokan'], 4)."</td>
                            <td><span class='badge bg-success'>Benefit</span></td>
                        </tr>
                        <tr class='table-primary'>
                            <td><strong>Total</strong></td>
                            <td><strong>{$total_bobot}</strong></td>
                            <td><strong>1.000000</strong></td>
                            <td></td>
                        </tr>
                    </table>
                  </div>";
            
            // 7.3. Hitung skor optimasi (Yi)
            $ranking = [];
            foreach ($normalized as $item) {
                $benefit = ($item['trend'] * $bobot['trend']) +
                           ($item['aktivitas'] * $bobot['aktivitas']) +
                           ($item['kecocokan'] * $bobot['kecocokan']);
                
                $cost = $item['harga'] * $bobot['harga'];
                $yi = $benefit - $cost;
                
                $ranking[] = [
                    'id' => $item['id'],
                    'nama' => $item['nama'],
                    'yi' => $yi,
                    'harga' => $item['harga'] * sqrt($sum_sq['harga']),
                    'trend' => $item['trend'] * sqrt($sum_sq['trend']),
                    'aktivitas' => $item['aktivitas'] * sqrt($sum_sq['aktivitas']),
                    'kecocokan' => $item['kecocokan'] * sqrt($sum_sq['kecocokan']),
                    'cluster' => $item['cluster'],
                    'style' => $item['style']
                ];
            }
            
            // Urutkan berdasarkan Yi tertinggi
            usort($ranking, function($a, $b) {
                return $b['yi'] <=> $a['yi'];
            });
            
            echo "<div class='mb-4'>
                    <h4>Langkah 4: Skor Optimasi (Yi)</h4>
                    <p>Rumus: <code>Yi = (Trend×wTrend) + (Aktivitas×wAktivitas) + (Kecocokan×wKecocokan) - (Harga×wHarga)</code></p>
                    <table class='table table-bordered'>
                        <thead>
                            <tr>
                                <th>Rank</th>
                                <th>Produk</th>
                                <th>Yi</th>
                                <th>Benefit</th>
                                <th>Cost</th>
                                <th>Detail Perhitungan</th>
                            </tr>
                        </thead>
                        <tbody>";
            
            foreach ($ranking as $i => $item) {
                $benefit = ($item['trend'] * $bobot['trend']) +
                           ($item['aktivitas'] * $bobot['aktivitas']) +
                           ($item['kecocokan'] * $bobot['kecocokan']);
                
                $cost = $item['harga'] * $bobot['harga'];
                
                $detail = "(".number_format($item['trend'],4)."×".number_format($bobot['trend'],4).") + ".
                          "(".number_format($item['aktivitas'],4)."×".number_format($bobot['aktivitas'],4).") + ".
                          "(".number_format($item['kecocokan'],4)."×".number_format($bobot['kecocokan'],4).") - ".
                          "(".number_format($item['harga'],4)."×".number_format($bobot['harga'],4).")";
                
                echo "<tr".($i < 3 ? " class='highlight'" : "").">
                        <td>".($i+1)."</td>
                        <td>{$item['nama']}</td>
                        <td>".number_format($item['yi'], 4)."</td>
                        <td>".number_format($benefit, 4)."</td>
                        <td>".number_format($cost, 4)."</td>
                        <td><small>{$detail}</small></td>
                      </tr>";
            }
            
            echo "</tbody></table></div>";
            ?>
        </div>

        <!-- Hasil Rekomendasi -->
        <div class="debug-section">
            <h2 class="text-primary">4. Hasil Rekomendasi</h2>
            
            <div class="alert alert-success">
                <h5>Rekomendasi Produk</h5>
                <p>Gaya: <strong><?= $user_cluster_gaya ?></strong> | Jumlah Produk: <?= count($ranking) ?></p>
            </div>
            
            <div class="row">
                <?php foreach (array_slice($ranking, 0, 6) as $i => $produk): ?>
                    <div class="col-md-4 mb-4">
                        <div class="card h-100 border-success">
                            <div class="card-header bg-success text-white">
                                <h5 class="card-title mb-0">#<?= $i+1 ?> <?= htmlspecialchars($produk['nama']) ?></h5>
                            </div>
                            <div class="card-body">
                                <table class="table table-sm">
                                    <tr>
                                        <th>Skor Yi</th>
                                        <td><?= number_format($produk['yi'], 4) ?></td>
                                    </tr>
                                    <tr>
                                        <th>Harga</th>
                                        <td><?= number_format($produk['harga'], 2) ?></td>
                                    </tr>
                                    <tr>
                                        <th>Trend</th>
                                        <td><?= number_format($produk['trend'], 2) ?></td>
                                    </tr>
                                    <tr>
                                        <th>Aktivitas</th>
                                        <td><?= number_format($produk['aktivitas'], 2) ?></td>
                                    </tr>
                                    <tr>
                                        <th>Kecocokan</th>
                                        <td><?= number_format($produk['kecocokan'], 2) ?></td>
                                    </tr>
                                </table>
                            </div>
                            <div class="card-footer">
                                <a href="https://shopee.co.id/search?keyword=<?= urlencode($produk['nama']) ?>" 
                                   target="_blank" class="btn btn-success w-100">
                                Lihat di Shopee
                                </a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            
            <!-- Tombol Kembali -->
            <div class="text-center mt-5">
                <a href="form.php" class="btn btn-lg btn-back">
                    ← Kembali ke Form Rekomendasi
                </a>
            </div>
        </div>

    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>