<?php 
include 'koneksi.php';
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Stylo Rekomendasi Fashion</title>
  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;600;700&family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
  
  <style>
    :root {
      --primary-color: #e83e8c;
      --secondary-color: #6c757d;
      --accent-color: #ffc107;
      --light-color: #f8f9fa;
      --dark-color: #343a40;
    }
    
    body {
      font-family: 'Poppins', sans-serif;
      background-color: #f5f5f5;
      color: #333;
      overflow-x: hidden;
    }
    
    .container {
      padding-left: 15px;
      padding-right: 15px;
      max-width: 100%;
    }
    
    @media (min-width: 768px) {
      .container {
        max-width: 720px;
      }
    }
    
    @media (min-width: 992px) {
      .container {
        max-width: 960px;
      }
    }
    
    .brand-logo {
      width: 180px;
      height: auto;
      margin-bottom: 1.5rem;
    }
    
    .question-container {
      width: 100%;
      max-width: 600px;
      opacity: 0;
      pointer-events: none;
      position: absolute;
      transition: opacity 0.5s ease;
      margin: 0 auto;
    }
    
    .question-container.active {
      opacity: 1;
      pointer-events: auto;
      position: relative;
    }
    
    .card-question {
      border-radius: 15px;
      border: 2px solid var(--primary-color);
      box-shadow: 0 10px 20px rgba(0,0,0,0.1);
      background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
      margin-bottom: 20px;
      overflow: hidden;
    }
    
    .card-header {
      background-color: var(--primary-color);
      color: white;
      border-radius: 13px 13px 0 0 !important;
      padding: 1.2rem;
    }
    
    .card-body {
      padding: 1.5rem;
    }
    
    .question {
      font-size: 1.2rem;
      font-weight: 600;
      color: var(--dark-color);
      margin-bottom: 1.5rem;
    }
    
    .btn-option {
      width: 100%;
      padding: 12px;
      margin-bottom: 10px;
      text-align: left;
      border: 2px solid #dee2e6;
      border-radius: 8px;
      transition: all 0.3s ease;
      background-color: white;
      color: var(--dark-color);
    }
    
    .btn-option:hover, .btn-option:focus {
      border-color: var(--primary-color);
      background-color: rgba(232, 62, 140, 0.1);
    }
    
    .btn-check:checked + .btn-option {
      background-color: var(--primary-color);
      color: white;
      border-color: var(--primary-color);
    }
    
    .btn-next {
      background-color: var(--primary-color);
      color: white;
      padding: 10px 25px;
      border-radius: 50px;
      font-weight: 600;
      border: none;
      transition: all 0.3s ease;
      margin-top: 1rem;
    }
    
    .btn-next:hover {
      transform: translateY(-3px);
      box-shadow: 0 5px 15px rgba(232, 62, 140, 0.4);
    }
    
    .btn-next:active {
      transform: translateY(0);
    }
    
    .progress-container {
      width: 100%;
      max-width: 600px;
      margin: 0 auto 2rem auto;
      padding: 0 15px;
    }
    
    .progress {
      height: 10px;
      border-radius: 5px;
      background-color: #e9ecef;
    }
    
    .progress-bar {
      background-color: var(--primary-color);
      transition: width 0.5s ease;
    }
    
    .step-indicator {
      font-size: 0.9rem;
      color: var(--secondary-color);
      text-align: center;
      margin-top: 0.5rem;
    }
    
    .intro-text {
      color: #6c757d;
      font-size: 0.95rem;
      margin-bottom: 1.5rem;
    }
    
    /* Animations */
    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(20px); }
      to { opacity: 1; transform: translateY(0); }
    }
    
    .fade-in {
      animation: fadeIn 0.5s ease forwards;
    }
    
    /* Floating background elements */
    .floating-bg {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      z-index: -1;
      overflow: hidden;
    }
    
    .floating-element {
      position: absolute;
      background-color: rgba(232, 62, 140, 0.1);
      border-radius: 50%;
      filter: blur(60px);
      opacity: 0.5;
    }
    
    /* Responsive adjustments */
    @media (max-width: 768px) {
      .card-question {
        border-radius: 10px;
      }
      
      .question {
        font-size: 1.1rem;
      }
      
      .btn-option {
        padding: 10px;
      }
    }
    
    /* Alignment fixes */
    .row.justify-content-center {
      margin-left: -15px;
      margin-right: -15px;
    }
    
    .col-lg-8, .col-md-10 {
      padding-left: 15px;
      padding-right: 15px;
    }
    
    .choices {
      margin-bottom: 1rem;
    }
  </style>
</head>
<body>
  <!-- Floating background elements -->
  <div class="floating-bg">
    <div class="floating-element" style="width: 300px; height: 300px; top: 10%; left: 5%;"></div>
    <div class="floating-element" style="width: 400px; height: 400px; bottom: 10%; right: 5%;"></div>
    <div class="floating-element" style="width: 200px; height: 200px; top: 50%; left: 30%;"></div>
  </div>

  <main class="py-5">
    <div class="container">
      <div class="progress-container">
        <div class="progress">
          <div class="progress-bar" id="progressBar" style="width: 14%"></div>
        </div>
        <div class="step-indicator" id="stepIndicator">1 dari 7</div>
      </div>
      
      <div class="row justify-content-center">
        <div class="col-lg-8 col-md-10">
          <form action="rekomendasi.php" method="POST" id="surveyForm">
            <input type="hidden" name="gender" id="input_gender">
            <input type="hidden" name="warna" id="input_warna">
            <input type="hidden" name="gaya" id="input_gaya">
            <input type="hidden" name="trend" id="input_trend">
            <input type="hidden" name="aktivitas_penting" id="input_aktivitas_penting">
            <input type="hidden" name="harga" id="input_harga">
            <input type="hidden" name="aktivitas" id="input_aktivitas">
            
            <!-- Question 1: Gender -->
            <div id="question1" class="card card-question question-container active fade-in">
              <div class="card-header text-center">
                <img src="lontara.png" alt="Logo" class="brand-logo">
                <h4>Selamat Datang di Stylo!</h4>
              </div>
              <div class="card-body">
                <p class="intro-text text-center">Yuk isi survei ini untuk membantu kami merekomendasikan gaya fashion yang paling cocok untukmu!</p>
                
                <div class="question text-center">Bagaimana kamu mendeskripsikan diri kamu?</div>
                
                <div class="choices">
                  <div class="d-grid gap-2 mb-3">
                    <input type="radio" class="btn-check" name="gender" id="choice1" value="Pria" autocomplete="off">
                    <label class="btn btn-option" for="choice1">
                      <i class="fas fa-mars me-2"></i> Maskulin
                    </label>
                  </div>
                  
                  <div class="d-grid gap-2 mb-3">
                    <input type="radio" class="btn-check" name="gender" id="choice2" value="Wanita" autocomplete="off">
                    <label class="btn btn-option" for="choice2">
                      <i class="fas fa-venus me-2"></i> Feminim
                    </label>
                  </div>
                </div>
                
                <div class="text-center">
                  <button type="button" class="btn btn-next" onclick="validateAndNext(2)">
                    Berikutnya <i class="fas fa-arrow-right ms-2"></i>
                  </button>
                </div>
              </div>
            </div>
            
            <!-- Question 2: Warna Favorit -->
            <div id="question2" class="card card-question question-container">
              <div class="card-header text-center">
                <img src="lontara.png" alt="Logo" class="brand-logo">
                <h4>Warna Favorit</h4>
              </div>
              <div class="card-body">
                <div class="question text-center">Warna apa yang paling kamu sukai?</div>
                
                <div class="choices">
                  <div class="d-grid gap-2 mb-3">
                    <input class="btn-check" type="radio" id="warna1" name="warna" value="Cerah">
                    <label class="btn btn-option" for="warna1">
                      <i class="fas fa-sun me-2"></i> Cerah
                    </label>
                  </div>
                  
                  <div class="d-grid gap-2 mb-3">
                    <input class="btn-check" type="radio" id="warna2" name="warna" value="Pastel">
                    <label class="btn btn-option" for="warna2">
                      <i class="fas fa-cloud me-2"></i> Pastel
                    </label>
                  </div>
                  
                  <div class="d-grid gap-2 mb-3">
                    <input class="btn-check" type="radio" id="warna3" name="warna" value="Hitam">
                    <label class="btn btn-option" for="warna3">
                      <i class="fas fa-moon me-2"></i> Hitam
                    </label>
                  </div>
                  
                  <div class="d-grid gap-2 mb-3">
                    <input class="btn-check" type="radio" id="warna4" name="warna" value="Putih">
                    <label class="btn btn-option" for="warna4">
                      <i class="fas fa-snowflake me-2"></i> Putih
                    </label>
                  </div>
                </div>
                
                <div class="text-center">
                  <button type="button" class="btn btn-next" onclick="validateAndNext(3)">
                    Berikutnya <i class="fas fa-arrow-right ms-2"></i>
                  </button>
                </div>
              </div>
            </div>
            
            <!-- Question 3: Kecocokan Warna -->
            <div id="question3" class="card card-question question-container">
              <div class="card-header text-center">
                <img src="lontara.png" alt="Logo" class="brand-logo">
                <h4>Kecocokan Warna</h4>
              </div>
              <div class="card-body">
                <div class="question text-center">Seberapa cocok warna <span id="selectedWarna" class="fw-bold text-primary">[...]</span> ini dengan dirimu?</div>
                
                <div class="choices">
                  <div class="d-grid gap-2 mb-3">
                    <input class="btn-check" type="radio" id="choice19" name="gaya" value="5">
                    <label class="btn btn-option" for="choice19">
                      <i class="fas fa-heart me-2"></i> Sangat menggambarkan gaya saya
                    </label>
                  </div>
                  
                  <div class="d-grid gap-2 mb-3">
                    <input class="btn-check" type="radio" id="choice21" name="gaya" value="4">
                    <label class="btn btn-option" for="choice21">
                      <i class="fas fa-thumbs-up me-2"></i> Cukup sesuai dengan gaya saya
                    </label>
                  </div>
                  
                  <div class="d-grid gap-2 mb-3">
                    <input class="btn-check" type="radio" id="choice32" name="gaya" value="3">
                    <label class="btn btn-option" for="choice32">
                      <i class="fas fa-meh me-2"></i> Netral atau kadang cocok
                    </label>
                  </div>
                  
                  <div class="d-grid gap-2 mb-3">
                    <input class="btn-check" type="radio" id="choice42" name="gaya" value="2">
                    <label class="btn btn-option" for="choice42">
                      <i class="fas fa-thumbs-down me-2"></i> Kurang sesuai
                    </label>
                  </div>
                  
                  <div class="d-grid gap-2 mb-3">
                    <input class="btn-check" type="radio" id="choice52" name="gaya" value="1">
                    <label class="btn btn-option" for="choice52">
                      <i class="fas fa-times-circle me-2"></i> Tidak cocok sama sekali
                    </label>
                  </div>
                </div>
                
                <div class="text-center">
                  <button type="button" class="btn btn-next" onclick="validateAndNext(4)">
                    Berikutnya <i class="fas fa-arrow-right ms-2"></i>
                  </button>
                </div>
              </div>
            </div>
            
            <!-- Question 4: Fashion Trends -->
            <div id="question4" class="card card-question question-container">
              <div class="card-header text-center">
                <img src="lontara.png" alt="Logo" class="brand-logo">
                <h4>Mengikuti Tren</h4>
              </div>
              <div class="card-body">
                <div class="question text-center">Seberapa kamu mengikuti perkembangan trend fashion?</div>
                
                <div class="choices">
                  <div class="d-grid gap-2 mb-3">
                    <input class="btn-check" type="radio" id="trend1" name="trend" value="1">
                    <label class="btn btn-option" for="trend1">
                      <i class="fas fa-times me-2"></i> Tidak mengikuti sama sekali
                    </label>
                  </div>
                  
                  <div class="d-grid gap-2 mb-3">
                    <input class="btn-check" type="radio" id="trend2" name="trend" value="2">
                    <label class="btn btn-option" for="trend2">
                      <i class="fas fa-info-circle me-2"></i> Hanya tahu sedikit, tidak terlalu peduli
                    </label>
                  </div>
                  
                  <div class="d-grid gap-2 mb-3">
                    <input class="btn-check" type="radio" id="trend3" name="trend" value="3">
                    <label class="btn btn-option" for="trend3">
                      <i class="fas fa-check-circle me-2"></i> Cukup mengikuti, jika sesuai selera
                    </label>
                  </div>
                  
                  <div class="d-grid gap-2 mb-3">
                    <input class="btn-check" type="radio" id="trend4" name="trend" value="4">
                    <label class="btn btn-option" for="trend4">
                      <i class="fas fa-fire me-2"></i> Aktif mengikuti dan suka eksplor tren
                    </label>
                  </div>
                  
                  <div class="d-grid gap-2 mb-3">
                    <input class="btn-check" type="radio" id="trend5" name="trend" value="5">
                    <label class="btn btn-option" for="trend5">
                      <i class="fas fa-bolt me-2"></i> Selalu update dan mengikuti tren terbaru
                    </label>
                  </div>
                </div>
                
                <div class="text-center">
                  <button type="button" class="btn btn-next" onclick="validateAndNext(5)">
                    Berikutnya <i class="fas fa-arrow-right ms-2"></i>
                  </button>
                </div>
              </div>
            </div>
            
            <!-- Question 5: Daily Activities -->
            <div id="question5" class="card card-question question-container">
              <div class="card-header text-center">
                <img src="lontara.png" alt="Logo" class="brand-logo">
                <h4>Aktivitas Harian</h4>
              </div>
              <div class="card-body">
                <div class="question text-center">Seberapa penting aktivitas harian kamu dalam menentukan gaya fashion?</div>
                
                <div class="choices">
                  <div class="d-grid gap-2 mb-3">
                    <input class="btn-check" type="radio" id="aktivitas_sangat_penting" name="aktivitas_penting" value="5">
                    <label class="btn btn-option" for="aktivitas_sangat_penting">
                      <i class="fas fa-exclamation-circle me-2"></i> Sangat Penting
                    </label>
                  </div>
                  
                  <div class="d-grid gap-2 mb-3">
                    <input class="btn-check" type="radio" id="aktivitas_penting" name="aktivitas_penting" value="4">
                    <label class="btn btn-option" for="aktivitas_penting">
                      <i class="fas fa-check-circle me-2"></i> Penting
                    </label>
                  </div>
                  
                  <div class="d-grid gap-2 mb-3">
                    <input class="btn-check" type="radio" id="aktivitas_biasa" name="aktivitas_penting" value="3">
                    <label class="btn btn-option" for="aktivitas_biasa">
                      <i class="fas fa-minus-circle me-2"></i> Biasa Saja
                    </label>
                  </div>
                  
                  <div class="d-grid gap-2 mb-3">
                    <input class="btn-check" type="radio" id="aktivitas_tidak_penting" name="aktivitas_penting" value="2">
                    <label class="btn btn-option" for="aktivitas_tidak_penting">
                      <i class="fas fa-times-circle me-2"></i> Tidak Penting
                    </label>
                  </div>
                </div>
                
                <div class="text-center">
                  <button type="button" class="btn btn-next" onclick="validateAndNext(6)">
                    Berikutnya <i class="fas fa-arrow-right ms-2"></i>
                  </button>
                </div>
              </div>
            </div>
            
            <!-- Question 6: Price -->
            <div id="question6" class="card card-question question-container">
              <div class="card-header text-center">
                <img src="lontara.png" alt="Logo" class="brand-logo">
                <h4>Budget Fashion</h4>
              </div>
              <div class="card-body">
                <div class="question text-center">Seberapa penting harga dalam memilih gaya fashion yang kamu inginkan?</div>
                
                <div class="choices">
                  <div class="d-grid gap-2 mb-3">
                    <input class="btn-check" type="radio" id="harga_sangat_mahal" name="harga" value="1">
                    <label class="btn btn-option" for="harga_sangat_mahal">
                      <i class="fas fa-money-bill-wave me-2"></i> Sangat tidak masalah dengan harga tinggi
                    </label>
                  </div>
                  
                  <div class="d-grid gap-2 mb-3">
                    <input class="btn-check" type="radio" id="harga_mahal" name="harga" value="2">
                    <label class="btn btn-option" for="harga_mahal">
                      <i class="fas fa-tag me-2"></i> Cenderung pilih yang branded
                    </label>
                  </div>
                  
                  <div class="d-grid gap-2 mb-3">
                    <input class="btn-check" type="radio" id="harga_sedang" name="harga" value="3">
                    <label class="btn btn-option" for="harga_sedang">
                      <i class="fas fa-balance-scale me-2"></i> Seimbang harga & gaya
                    </label>
                  </div>
                  
                  <div class="d-grid gap-2 mb-3">
                    <input class="btn-check" type="radio" id="harga_murah" name="harga" value="4">
                    <label class="btn btn-option" for="harga_murah">
                      <i class="fas fa-piggy-bank me-2"></i> Suka harga terjangkau
                    </label>
                  </div>
                  
                  <div class="d-grid gap-2 mb-3">
                    <input class="btn-check" type="radio" id="harga_sangat_murah" name="harga" value="5">
                    <label class="btn btn-option" for="harga_sangat_murah">
                      <i class="fas fa-coins me-2"></i> Utamakan hemat
                    </label>
                  </div>
                </div>
                
                <div class="text-center">
                  <button type="button" class="btn btn-next" onclick="validateAndNext(7)">
                    Berikutnya <i class="fas fa-arrow-right ms-2"></i>
                  </button>
                </div>
              </div>
            </div>
            
            <!-- Question 7: Activities -->
            <div id="question7" class="card card-question question-container">
              <div class="card-header text-center">
                <img src="lontara.png" alt="Logo" class="brand-logo">
                <h4>Aktivitas Sehari-hari</h4>
              </div>
              <div class="card-body">
                <div class="question text-center">Apa aktivitas harian kamu?</div>
                
                <div class="choices">
                  <div class="d-grid gap-2 mb-3">
                    <input class="btn-check" type="radio" id="choice11" name="aktivitas" value="Mahasiswa">
                    <label class="btn btn-option" for="choice11">
                      <i class="fas fa-user-graduate me-2"></i> Aktif di lingkungan kampus
                    </label>
                  </div>
                  
                  <div class="d-grid gap-2 mb-3">
                    <input class="btn-check" type="radio" id="choice12" name="aktivitas" value="Pekerja Kantoran">
                    <label class="btn btn-option" for="choice12">
                      <i class="fas fa-briefcase me-2"></i> Bekerja di jam tetap
                    </label>
                  </div>
                  
                  <div class="d-grid gap-2 mb-3">
                    <input class="btn-check" type="radio" id="choice13" name="aktivitas" value="Freelancer">
                    <label class="btn btn-option" for="choice13">
                      <i class="fas fa-laptop-house me-2"></i> Kerja fleksibel dari mana saja
                    </label>
                  </div>
                  
                  <div class="d-grid gap-2 mb-3">
                    <input class="btn-check" type="radio" id="choice14" name="aktivitas" value="Pelajar">
                    <label class="btn btn-option" for="choice14">
                      <i class="fas fa-book-open me-2"></i> Aktif belajar setiap hari
                    </label>
                  </div>
                </div>
                
                <div class="text-center">
                  <button type="button" class="btn btn-next" onclick="finishQuiz()">
                    <i class="fas fa-check-circle me-2"></i> Selesai
                  </button>
                </div>
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>
  </main>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  <script>
    let selectedWarna = "";
    const totalQuestions = 7;
    
    // Save warna selection when radio is clicked
    document.addEventListener('DOMContentLoaded', function () {
      document.querySelectorAll('input[name="warna"]').forEach((radio) => {
        radio.addEventListener('change', function () {
          selectedWarna = this.value;
        });
      });
      
      // Update progress bar
      updateProgress(1);
    });
    
    // Validate before moving to next question
    function validateAndNext(next) {
      const currentQuestion = document.querySelector('.question-container.active');
      const questionNumber = parseInt(currentQuestion.id.replace('question', ''));
      const inputs = currentQuestion.querySelectorAll('input[type="radio"]:checked');
      
      if (inputs.length === 0) {
        alert('Silakan pilih salah satu jawaban sebelum melanjutkan');
        return;
      }
      
      // Save value to hidden input if needed
      if (questionNumber === 1) {
        document.getElementById('input_gender').value = inputs[0].value;
      } else if (questionNumber === 2) {
        document.getElementById('input_warna').value = inputs[0].value;
      }
      
      nextQuestion(next);
    }
    
    // Move to next question
    function nextQuestion(next) {
      // Inject warna to question 3 if going to question3
      if (next === 3 && selectedWarna !== "") {
        const warnaTarget = document.getElementById("selectedWarna");
        if (warnaTarget) {
          warnaTarget.textContent = selectedWarna;
        }
      }
      
      // Fade out animation
      let current = document.querySelector('.question-container.active');
      if (current) {
        current.classList.remove('active', 'fade-in');
        current.classList.add('fade-out');
        
        setTimeout(() => {
          current.classList.remove('fade-out');
          
          // Move to next question
          let nextQ = document.getElementById('question' + next);
          if (nextQ) {
            nextQ.classList.add('active', 'fade-in');
            updateProgress(next);
          }
        }, 300);
      }
    }
    
    // Update progress bar
    function updateProgress(currentStep) {
      const progressPercent = (currentStep / totalQuestions) * 100;
      document.getElementById('progressBar').style.width = progressPercent + '%';
      document.getElementById('stepIndicator').textContent = currentStep + ' dari ' + totalQuestions;
      
      // Scroll to top
      window.scrollTo({ top: 0, behavior: 'smooth' });
    }
    
    // Finish quiz
    function finishQuiz() {
      // Validate last question
      const inputs = document.querySelectorAll('#question7 input[type="radio"]:checked');
      if (inputs.length === 0) {
        alert('Silakan pilih aktivitas harian kamu sebelum menyelesaikan kuis');
        return;
      }
      
      // Get all selected radio values and put into hidden inputs
      document.getElementById('input_gaya').value = document.querySelector('input[name="gaya"]:checked')?.value || '';
      document.getElementById('input_trend').value = document.querySelector('input[name="trend"]:checked')?.value || '';
      document.getElementById('input_aktivitas_penting').value = document.querySelector('input[name="aktivitas_penting"]:checked')?.value || '';
      document.getElementById('input_harga').value = document.querySelector('input[name="harga"]:checked')?.value || '';
      document.getElementById('input_aktivitas').value = document.querySelector('input[name="aktivitas"]:checked')?.value || '';
      
      // Submit form
      document.getElementById('surveyForm').submit();
    }
  </script>
</body>
</html>