<?php
session_start();
include 'koneksi.php';

// Set header JSON
header('Content-Type: application/json');

// Ambil data dari form
$product_id = $_POST['product_id'] ?? null;
$user_session = $_POST['user_session'] ?? null;
$rating = $_POST['rating'] ?? null;

// Validasi data
if ($product_id === null || $user_session === null || $rating === null) {
    echo json_encode(['success' => false, 'message' => 'Data tidak lengkap']);
    exit();
}

// Pastikan rating adalah angka 0 atau 1
$rating = (int)$rating;
if ($rating != 0 && $rating != 1) {
    echo json_encode(['success' => false, 'message' => 'Rating tidak valid']);
    exit();
}

try {
    // Cek apakah user sudah memberikan rating untuk produk ini
    $check_sql = "SELECT id FROM ground_truth WHERE user_session = ? AND product_id = ?";
    $check_stmt = $db->prepare($check_sql);
    $check_stmt->bind_param("si", $user_session, $product_id);
    $check_stmt->execute();
    $check_result = $check_stmt->get_result();

    if ($check_result->num_rows > 0) {
        // Update rating yang sudah ada
        $update_sql = "UPDATE ground_truth SET user_rating = ?, rated_at = CURRENT_TIMESTAMP WHERE user_session = ? AND product_id = ?";
        $update_stmt = $db->prepare($update_sql);
        $update_stmt->bind_param("isi", $rating, $user_session, $product_id);
        $success = $update_stmt->execute();
    } else {
        // Insert rating baru
        $insert_sql = "INSERT INTO ground_truth (user_session, product_id, user_rating, rated_at) VALUES (?, ?, ?, CURRENT_TIMESTAMP)";
        $insert_stmt = $db->prepare($insert_sql);
        $insert_stmt->bind_param("sii", $user_session, $product_id, $rating);
        $success = $insert_stmt->execute();
    }

    if ($success) {
        echo json_encode(['success' => true, 'message' => 'Rating berhasil disimpan']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Gagal menyimpan rating']);
    }
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Error database: ' . $e->getMessage()]);
}
?>